# -*- coding: utf-8 -*-
"""
Created on Fri Feb 28 07:48:15 2020

@author: Pascal Gehring
"""

directory = ''

stabdata = '142034_St05_d06_heaterfanAC_Iheat0.30_to_0.30V_vgate-1_to_0mV_2.08K.dat'






import numpy as np
import matplotlib.pyplot as plt
import os as os
import scipy.signal as ss
from scipy.optimize import fsolve
from scipy.optimize import least_squares


impdat = np.loadtxt(directory + stabdata)
Gate = np.unique(impdat[:,2])
Bias = np.unique(impdat[:,3])
Ith = np.reshape(impdat[:,5],[len(Gate),len(Bias)])
Ith = np.transpose(Ith)
Ith = np.fliplr(Ith)*1e-9 #nA
dIdV = np.reshape(impdat[:,8],[len(Gate),len(Bias)])
dIdV = np.transpose(dIdV)
dIdV = np.fliplr(dIdV)*1e-6 #uS
IDC = np.reshape(impdat[:,10],[len(Gate),len(Bias)])
IDC = np.transpose(IDC)
IDC = np.fliplr(IDC)*1e-9 #nA


dT = 0.82 #K
kBsi=1.381e-23 #m2kg s-2 K-1
hsi=6.626e-34 #m2 kg/s
q = 1.6022e-19 #electron charge

S = -Ith/dIdV/dT
PF = (Ith/dT)**2/dIdV




plt.figure()
img = plt.pcolormesh(Gate,Bias,IDC*1e12,cmap='RdBu_r',vmin=-10, vmax=10)
cbar = plt.colorbar()
cbar.set_label('DC current (pA)', rotation=270, labelpad=10)
plt.ylabel('Bias (mV)')
plt.xlabel('Gate (V)')

plt.figure()
img = plt.pcolormesh(Gate,Bias,dIdV*1e9,cmap='magma_r',vmin=0, vmax=4)
cbar = plt.colorbar()
cbar.set_label('dI/dV (nS)', rotation=270, labelpad=10)
plt.ylabel('Bias (mV)')
plt.xlabel('Gate (V)')

plt.figure()
img = plt.pcolormesh(Gate,Bias,Ith*1e12,cmap='RdBu_r',vmin=-0.5, vmax=0.5)
cbar = plt.colorbar()
cbar.set_label('Thermocurrent (pA)', rotation=270, labelpad=10)
plt.ylabel('Bias (mV)')
plt.xlabel('Gate (V)')


plt.figure()
img = plt.pcolormesh(Gate,Bias,S*1e6,cmap='RdBu_r',vmin=-400, vmax=400)
cbar = plt.colorbar()
cbar.set_label('Seebeck coefficient ($\mu$V K$^{-1}$)', rotation=270, labelpad=10)
plt.ylabel('Bias (mV)')
plt.xlabel('Gate (V)')
plt.savefig('Seebeckmap.pdf')


plt.figure()
img = plt.pcolormesh(Gate,Bias,PF*1e4/(kBsi**2/hsi),cmap='magma_r',vmin=0, vmax=4)
cbar = plt.colorbar()
cbar.set_label('Powerfactor ($10^{4}$ x $k_{B}^2/h$)', rotation=270, labelpad=20)
plt.ylabel('Bias (mV)')
plt.xlabel('Gate (V)')


plt.figure()
img = plt.plot(Gate,dIdV[51,:]*1e9,'.')
plt.xlabel('Gate (V)')
plt.ylabel('dI/dV (nS)')


plt.figure()
img = plt.plot(Gate,Ith[51,:]*1e12,'.')
plt.xlabel('Gate (V)')
plt.ylabel('Thermocurrent (pA)')
